/*
 * Command Line Parser
 *
 * Copyright (C) 2009-2011 Udo Steinberg <udo@hypervisor.org>
 * Economic rights: Technische Universitaet Dresden (Germany)
 *
 * This file is part of the NOVA microhypervisor.
 *
 * NOVA is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * NOVA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License version 2 for more details.
 */

#pragma once

#include "compiler.h"
#include "types.h"

class Cmdline
{
    private:
        static struct param_map
        {
            char   const *arg;
            bool * const  ptr;
        } map[];

        INIT
        static char *get_arg (char **line);

    public:
        static bool iommu;
        static bool keyb;
        static bool serial;
        static bool spinner;
        static bool vtlb;
        static bool novga;
        static bool novpid;

        INIT
        static void init (mword);
};
