/*
 * Kernel Object
 *
 * Copyright (C) 2009-2011 Udo Steinberg <udo@hypervisor.org>
 * Economic rights: Technische Universitaet Dresden (Germany)
 *
 * This file is part of the NOVA microhypervisor.
 *
 * NOVA is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * NOVA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License version 2 for more details.
 */

#pragma once

#include "compiler.h"
#include "mdb.h"
#include "refptr.h"
#include "spinlock.h"

class Kobject : public Mdb
{
    private:
        uint8 objtype;

        static void free (Rcu_elem *) {}

    protected:
        Spinlock lock;

        enum Type
        {
            PD,
            EC,
            SC,
            PT,
            SM,
            INVALID,
        };

        explicit Kobject (Type t, Pd *pd, mword b, mword a = perm) : Mdb (pd, reinterpret_cast<mword>(this), b, a, free), objtype (t) {}

    public:
        static mword const perm = 0x1f;

        ALWAYS_INLINE
        inline Type type() const
        {
            return EXPECT_TRUE (this) ? Type (objtype) : INVALID;
        }
};
