-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.Dt.add_children(hw_bus, function()

  -- create a new hardware device
  LED = Hw.Device(function()
    -- Set the 'compatible' IDs for the device
    compatible = {"gpio-led,green", "gpio-led",};

    -- set 'hid' property
    Property.hid = "gpio-led,D7";

    -- Add a GPIO pin as 'gled' resource to the device
    -- on Beagleboard this is the green user LED D7
    Resource.led = Io.Gpio_resource(hw_bus.GPIO.GPIO5, 21, 21);
  end);
end)
