-- vi:ft=lua

local Hw = Io.Hw
local hw_bus = Io.system_bus()

-- add devices to io's device tree
Io.hw_add_devices(function()

  -- create a new hardware device
  BTN = Hw.Device(function()
    -- Set the 'compatible' IDs for the device
    compatible = {"gpio-input,btn","gpio-key"};

    -- Set the 'hid' property of the device
    Property.hid = "gpio-key,User"

    -- Add a GPIO pin as a resource to the device
    Resource.key = Io.Gpio_resource(hw_bus.GPIO, 22, 22);
  end);
end)

