#pragma once

#include <libunwind_i.h>

#include <libbacktrace/backtrace.h>

// We have to cache these states, because libbacktrace offers no method to free once allocated states.
// We cannot also not unmap the elf image, as backtrace data structures still refer to it!
typedef struct elf_image_handle
{
  struct elf_image ei;
  char path[256];
} elf_image_handle_t;

elf_image_handle_t *get_elf_image(char const *path);

struct backtrace_state *get_backtrace_state(elf_image_handle_t *elf,
                                            backtrace_error_callback error_cb,
                                            void *data);
