#ifndef os_l4_h
#define os_l4_h

#include <sys/types.h>

#include <l4/re/c/rm.h>

/* The region manager exposes an interface to iterate the loaded modules of
   a process. */
pid_t
l4_to_pid(l4_cap_idx_t rm);

l4_cap_idx_t
pid_to_l4(pid_t pid);

int
l4_find_elf (l4_cap_idx_t rm, l4_addr_t addr, unsigned long *segbase,
             unsigned long *mapoff, char *path, size_t pathlen);

#endif /* os_l4_h */
