/*
 * Copyright (C) 2008-2011 Technische Universität Dresden.
 * Author(s): Adam Lackorzynski <adam@os.inf.tu-dresden.de>
 *
 * License: see LICENSE.spdx (in this directory or the directories above)
 */

/*!
 * \file
 * \brief  Support for the rv platform
 */

#include "support.h"
#include "startup.h"
#include "platform-arm.h"

#include <l4/drivers/uart_pl011.h>

namespace {

class Platform_arm_rv : public Platform_single_region_ram<Platform_arm>
{
  bool probe() override { return true; }
  void init() override
  {
    kuart.base_address = 0x10009000;
    kuart.base_baud    = 24019200;
    kuart.baud         = 115200;
    kuart.irqno        = 36; // hm, would be 44 for PBX or non-MPCORE realview
    kuart.access_type  = L4_kernel_options::Uart_type_mmio;
    kuart_flags       |=   L4_kernel_options::F_uart_base
                         | L4_kernel_options::F_uart_baud
                         | L4_kernel_options::F_uart_irq;

    static L4::Io_register_block_mmio r(kuart.base_address);
    static L4::Uart_pl011 _uart(kuart.base_baud);
    _uart.startup(&r);
    set_stdio_uart(&_uart);
  }
};

}

REGISTER_PLATFORM(Platform_arm_rv);
