#pragma once

#include <l4/sys/compiler.h>

#define __NEED_locale_t
#define __NEED_size_t
#define __NEED_uintptr_t
#define __NEED_pthread_t
#include <bits/alltypes.h>

#ifndef __DEFINED_pthread_descr
typedef struct pthread *pthread_descr;
#define __DEFINED_pthread_descr
#endif

// This is really hacky, this should be included in pthread_impl.h in musl, but
// we include it here to get access to TLS_ABOVE_TP. Mhm, maybe move this libc
// specific part to musl!!! And only the funcs below stay general, yay, sounds
// nice.
// Than musl could provide the PRIVATE_INCDIR that libpthread needs.
#include "pthread_arch.h"

#ifndef TLS_ABOVE_TP
#define TLS_PTHREAD_LIBC_DATA_AT_HEAD
#endif

// L4Re abstraction
typedef struct pthread_libc_data
{
  /* x86 -- these fields may be external or
   * internal (accessed via asm) ABI. Do not change. */
#ifndef TLS_ABOVE_TP
  void *self_tp; // accessed from __get_tp
  uintptr_t *dtv; // accessed from tlsdesc.s
  uintptr_t _pad[2]; /* non-ABI */
  uintptr_t sysinfo;
  uintptr_t canary; // THIS is directly accessed by code generated by the compiler, must be at offset fs:40 (on x86_64) and gs:20 (on x86)!
#endif

  int errno_val;
  unsigned char dlerror_flag : 1;
  // NOTE: For deallocation of TLS block, maybe not strictly necessary, we might
  // be able to compute it from tp pointer.
  unsigned char *map_base;
  size_t map_size;
  locale_t locale;
  char *dlerror_buf;

  /* non x86 - the positions of these fields relative to
   * the end of the structure is external and internal ABI. */
#ifdef TLS_ABOVE_TP
  uintptr_t canary;
  uintptr_t *dtv; // accessed from tlsdesc.s
#endif
} pthread_libc_data_t;

L4_BEGIN_DECLS

// Must be called early on to setup libpthread.
L4_HIDDEN void __pthread_initialize_minimal(void *arg);

/**
 * Essential parts of the setup done in __pthread_l4_initialize_main_thread(),
 * once the first pthread is started. However, since musl alaways uses a
 * pthread_descr for the main thread, even if libpthread is never used to
 * start any threads, we need to replicate some of the setup code here, to
 * make __pthread_self() work.
 */
L4_HIDDEN void __pthread_l4_initialize_dynlink_thread(pthread_descr descr);

L4_HIDDEN pthread_t __pthread_self(void);
L4_HIDDEN pthread_descr __pthread_thread_self(void);
L4_HIDDEN pthread_t __pthread_descr_to_handle(pthread_descr descr);
L4_HIDDEN pthread_libc_data_t *__pthread_libc_data(pthread_t id);
// TODO: Maybe instead give musl direct access to `struct pthread`?
L4_HIDDEN pthread_libc_data_t *__pthread_descr_libc_data(pthread_descr descr);
// TODO: Maybe instead give musl direct access to `struct pthread`?
L4_HIDDEN size_t __pthread_struct_size(void);

typedef struct l4_pthread_mgr_iface
{
  pthread_descr (*first_thread)(void);
  pthread_descr (*next_thread)(pthread_descr);
} l4_pthread_mgr_iface_t;

/**
 * If the manager has not yet been started, i.e. because no thread has been
 * created yet, this executes the function locally in context of the caller.
 */
void pthread_l4_exec_in_manager(void (*fn)(l4_pthread_mgr_iface_t const *mgr, void *arg), void *arg);


L4_END_DECLS
