# libunwind

This package contains libunwind adapted for the L4Re operating system.

Furthermore, this package provides an backtracer server which, using libunwind's
remote mode functionality, provides stacktraces of execution states for other
applications.

Depending on the architecture (and compiler?) it may be necessary to instruct
the compiler to generate unwind tables (see L4Re Kconfig -> Building -> Emit
unwind tables), otherwise libunwind won't be able to unwind the call stack.

If debug information is available in the binaries, the backtracer uses
libbacktrace to annotate the stacktrace with function name, source file name
and line lumber.

# Update libunwind contrib

The copy of libunwind included in this package comes from the libunwind git
repository. This should be considered when updating, as the published tar
release files differ slightly.

The following procedure is recommended:
- Clone libunwind git repository
- Checkout out the desired version
- Sync changed files to the libunwind copy in this package
- Run ./configure in the libunwind git repository to generate following files:
  config.h, libunwind-common.h and libunwind.h
- Sync changes in the generated files to the libunwind copy in this package

# TODO

- In contrast to dynamically linked binaries, statically linked L4Re binaries
  have no EH_FRAME program header and no .eh_frame_hdr section, even if unwind
  table generation is enabled. Thus no lookup table for the unwind tables is
  available, so libunwind has to fall back to slow linear search.

# Example
A simple ned configuration using the remote backtracer could look like this:

```lua
  local L4 = require("L4");
  local ld = L4.default_loader;

  -- Channel for backtracer
  local backtracer = ld:new_channel();

  -- The backtracer program, getting the channel in server mode.
  ld:start({ caps = { backtracer = backtracer:svr() },
             log = { "server", "blue" } },
           "rom/backtracer");

  -- The hello program, getting the 'backtracer' channel to be able to request
  -- the backtracer to do a stacktrace, for example when it encounters an
  -- unhandled exception.
  ld:start({ caps = { backtracer = backtracer },
             log = { "client", "green" } },
           "rom/hello");
```
