#include <iostream>
#include <fstream>
#include <filesystem>
#include <thread>
#include <chrono>
#include <iomanip>
#include <vector>

namespace fs = std::filesystem;

const std::string cgroup_base_path = "/sys/fs/cgroup/socker/";

std::string read_file_value(const fs::path& file_path) {
    std::ifstream file(file_path);
    std::string value;
    if (file) {
        std::getline(file, value);
    } else {
        value = "N/A";
    }
    return value;
}

void print_header() {
    std::cout << std::left
              << std::setw(20) << "Container Name"
              << std::setw(10) << "Mem"
              << std::setw(15) << "Mem (Limit)"
              << std::setw(10) << "Swap"
              << std::setw(15) << "Swap (Limit)"
              << std::setw(10) << "CPU"
              << std::endl;
    std::cout << std::string(85, '-') << std::endl;
}

void monitor_cgroups() {
    while (true) {
        std::vector<std::tuple<std::string, std::string, std::string, std::string, std::string, std::string>> entries;


        if (fs::exists(cgroup_base_path) && fs::is_directory(cgroup_base_path)) {
            for (const auto& dir_entry : fs::recursive_directory_iterator(cgroup_base_path)) {
                if (dir_entry.is_directory()) {
                    fs::path path = dir_entry.path();
                    std::string memory = read_file_value(path / "memory.current");
                    std::string swap = read_file_value(path / "memory.swap.current");
                    std::string memory_max = read_file_value(path / "memory.max");
                    std::string swap_max = read_file_value(path / "memory.swap.max");
                    std::string cpu_idle = read_file_value(path / "cpu.stat");

                    if(cpu_idle.find("usage_usec", 0) == 0) cpu_idle = cpu_idle.substr(11);

                    entries.emplace_back(path.filename().string(), memory, memory_max, swap, swap_max, cpu_idle);
                }
            }
        }       

        // Clear screen
        std::cout << "\033[2J\033[1;1H";
        print_header();

        for (const auto& [name, memory, memory_max, swap, swap_max, cpu_idle] : entries) {
            std::cout << std::left
                      << std::setw(20) << name
                      << std::setw(10) << memory
                      << std::setw(15) << memory_max
                      << std::setw(10) << swap
                      << std::setw(15) << swap_max
                      << std::setw(10) << cpu_idle
                      << std::endl;
        }

        std::this_thread::sleep_for(std::chrono::milliseconds(500));
    }
}

int main() {

    monitor_cgroups();
    return 0;
}
