#include <l4/sys/compiler.h>
#include <l4/sys/consts.h>
#include <l4/sys/vcon.h>

// this is a tiny L4Re "Hello World" program, in which we play a few dirty
// tricks to avoid pulling in too much unnecessary code from UCLIBC; don't do
// this at home

// 1) we provide a custom exit function that does not actually exit the
//    program, but also does not pull in unwanted UCLIBC dependencies
void L4_NORETURN _exit(int);
void L4_NORETURN _exit(int error)
{
	(void)error;
  	while (1) {
  		// nothing
  	}
}

// 2) we make the internal UCLIBC exit handler visible for step 4) below
extern void (*__exit_cleanup)(int);

int main(int argc, char const *argv[])
{
	(void)argc;
	(void)argv;

	// 3) we use the L4Re kernel debugger console to print our "Hello World"
	//    message
	l4_vcon_write(L4_BASE_LOG_CAP, "Hello, I am faulty.\n", 21);

	// 4) somehow, the UCLIBC exit handler is not initialiazed correctly in
	//    this minimized program; we disable it for this tiny program, as it
	//    is not needed anyway
	__exit_cleanup = 0;
	return 0;
}
