#pragma once

#include "cxx/type_traits"

// trivial, used to terminate the variadic recursion
template<typename A>
constexpr A const &
min(A const &a)
{ return a; }

// matches with automatic argument type deduction
template<typename A, typename ...ARGS>
constexpr A const &
min(A const &a1, A const &a2, ARGS const &...a)
{
  return min((a1 <= a2) ? a1 : a2, a...);
}

// matches with explicit template type A
template<typename A, typename ...ARGS>
constexpr A const &
min(cxx::identity_t<A> const &a1,
    cxx::identity_t<A> const &a2,
    ARGS const &...a)
{
  return min<A>((a1 <= a2) ? a1 : a2, a...);
}

// trivial, used to terminate the variadic recursion
template<typename A>
constexpr A const &
max(A const &a)
{ return a; }

// matches with automatic argument type deduction
template<typename A, typename ...ARGS>
constexpr A const &
max(A const &a1, A const &a2, ARGS const &...a)
{ return max((a1 >= a2) ? a1 : a2, a...); }

// matches with explicit template type A
template<typename A, typename ...ARGS>
constexpr A const &
max(cxx::identity_t<A> const &a1,
    cxx::identity_t<A> const &a2,
    ARGS const &...a)
{
  return max<A>((a1 >= a2) ? a1 : a2, a...);
}

