/*!
 * \file
 * \brief  Support for Marvell Armada 38x
 *
 * \date   2015
 * \author Adam Lackorzynski <adam@l4re.org>
 *
 */
/*
 * (c) 2015 Author(s)
 *
 * License: see LICENSE.spdx (in this directory or the directories above)
 */

#include "platform-arm.h"
#include "mmio_16550.h"

namespace {
class Platform_arm_armada38x : public Platform_single_region_ram<Platform_arm>
{
  bool probe() override { return true; }

  void init() override
  {
    kuart.base_address = 0xf1012000;
    kuart.base_baud    = 15625000;
    kuart.baud         = 115200;
    kuart.irqno        = 44;
    kuart.reg_shift    = 2;
    kuart.access_type  = L4_kernel_options::Uart_type_mmio;
    kuart_flags       |=   L4_kernel_options::F_uart_base
                         | L4_kernel_options::F_uart_baud
                         | L4_kernel_options::F_uart_irq;
    static L4::Uart_16550 _uart(kuart.base_baud, 0, 0, 0, 0);
    setup_16550_mmio_uart(&_uart);
  }
};
}

REGISTER_PLATFORM(Platform_arm_armada38x);
